--------------------------------------------------------------------------------------------
-- Render Button Menu Items Actions 
--------------------------------------------------------------------------------------------

--------------------------------------
-- Active Shade Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_ActiveShade_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_ACTIVESHADE_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_ACTIVESHADE_MODE_TOOLTIP~ 

(
	on execute do
	(
        --call this before changing the render settings for UI consistency		
        maxOps.rendUseIterative = false
        renderers.target = "local"
		renderers.renderDialogMode = #activeShade
		--~RENDERBUTTON_CAPTION_ACTIVESHADE~
	)

 	on ischecked return (renderers.renderDialogMode == #activeShade)
)--end macro

--------------------------------------
-- Production Rendering  Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Production_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_PRODUCTION_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_PRODUCTION_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = false
		renderers.target = "local"
		renderers.renderDialogMode = #production
		--~RENDERBUTTON_CAPTION_PRODUCTION~
	)

	on ischecked return (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == false AND rendUseNet == false AND renderers.target == "local") 
)--end macro


--------------------------------------
--  Iterative Rendering Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Iterative_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_ITERATIVE_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_ITERATIVE_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = true
		renderers.target = "local"
		renderers.renderDialogMode = #production
	)
	
	on ischecked return  (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == true AND rendUseNet == false )	
)--end macro


--------------------------------------
--  Network Rendering
--------------------------------------
MacroScript RenderButtonMenu_Submit_to_Network_Rendering
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SUBMIT_TO_NETWORK_RENDER_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SUBMIT_TO_NETWORK_RENDER_TOOLTIP~ 

(
	on execute do
	(
		--Modifications have to be done with render dialog closed
		renderSceneDialog.close()

		--switch to production renderer if we were not in that mode and store the old mode
		-- before switching
		oldTarget 			 = renderers.target
		oldmode 			 = renderers.renderDialogMode
		oldUseIterativeValue = maxOps.rendUseIterative

		if (oldTarget != "local")do
		(
			renderers.target = "local"
		)

		if (oldmode != #production) do
		(
			renderers.renderDialogMode = #production
		)

		if (oldUseIterativeValue != false)do
		(
			maxOps.rendUseIterative = false
		)
		
		--enable net render
		oldUseNetValue = rendUseNet
		rendUseNet     = true
		--Simulate press render button in render dialog
		max quick render

		--Reset everything back to previous state
		rendUseNet 				= oldUseNetValue
		maxOps.rendUseIterative = oldUseIterativeValue
		renderers.target 		= oldTarget
		if (oldmode != #production) do
		(
			renderers.renderDialogMode = oldmode
		)
		renderSceneDialog.open()
	)
)--end macro


--------------------------------------
-- Cloud Rendering  Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Cloud_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_CLOUD_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_CLOUD_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = false
		renderers.renderDialogMode = #production
		--~RENDERBUTTON_CAPTION_PRODUCTION~
		renderers.target = "cloud"
	)

	on ischecked return (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == false AND rendUseNet == false AND renderers.target == "cloud") 
)--end macro

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQANHF+kyBBDj7ls3kLBRrVdYFMzwzxUjhGM
-- cEY4FVuKvkcKdn66qtGwCzXqs51wdEi6Pv8LP/MdOywRqAEyIc340w1OSvlF8HYy
-- ojCgQOchqRK6GsuhwMbVJbAXqm7pSQ0nQ42TabmC09hGe2YiRdnsCAcSkksy4QR5
-- kTIgQSMpTKKUvX78QQ4Sz+m4XB2AshzKJeceYcWTxw2LZAZEp8LcGUp+7Z6HDu1F
-- Nq6EanBjK5S5TPRdx6bZygMQghUdCJCADfHS3NifQRN5AONmZgPR8Y3DytsPrsa6
-- ZV1Mre88on9+WC2gIF2i4n89D6xcUcS+DHTKg1YBMiK3J7D5la1t
-- -----END-SIGNATURE-----